#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/shm.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <errno.h>
#include <semaphore.h>

#define MAX_NAME_LENGTH 30
#define MAX_DESCRIPTION_LENGTH 200
#define MAX_TAG_LENGTH 30
#define N 50

typedef struct Articulos
{
  char name[MAX_NAME_LENGTH];               /* Nombre del aritculo*/
  int precio;                               /* Precio del articulo */
  char descripcion[MAX_DESCRIPTION_LENGTH]; /* Descricion del arituclo */
  int cantidad;                             /* Cantidad disponible del articulo */
  char tag[MAX_TAG_LENGTH];                 /* Etiquetas del articulo */
} articulo;

typedef struct Circular_List
{
  int head; /* first element index */
  articulo articulos[N];
} list;

void printArt(articulo);
void inventarioInicial(list *);

int main()
{
  const char *sh_name = "/inventario"; // shared memory descriptor name
  const char *sh_name2 = "/carrito";   // shared memory descriptor name

  const int SIZE = sizeof(list); // file size
  int shm_fd;                    // file descriptor, from shm_open()
  int shm_fd2;                   // file descriptor, from shm_open()
  list *shm_base;                // base address, from mmap()
  list *shm_base2;               // base address, from mmap()
  list *ptr_list;                // shm_base is fixed, ptr is movable

  /* create the shared memory segment as if it was a file */
  shm_fd = shm_open(sh_name, O_CREAT | O_RDWR, 0666);
  if (shm_fd == -1)
  {
    printf("prod: Shared memory failed: %s\n", strerror(errno));
    exit(1);
  }

  shm_fd2 = shm_open(sh_name2, O_CREAT | O_RDWR, 0666);
  if (shm_fd == -1)
  {
    printf("prod: Shared memory failed: %s\n", strerror(errno));
    exit(1);
  }

  /* configure the size of the shared memory segment */
  ftruncate(shm_fd, SIZE);
  ftruncate(shm_fd2, SIZE);

  /* map the shared memory segment to the address space of the process */
  shm_base = mmap(0, SIZE, PROT_READ | PROT_WRITE, MAP_SHARED, shm_fd, 0);
  if (shm_base == MAP_FAILED)
  {
    printf("prod: Map failed: %s\n", strerror(errno));
    exit(1);
  }

  shm_base2 = mmap(0, SIZE, PROT_READ | PROT_WRITE, MAP_SHARED, shm_fd2, 0);
  if (shm_base2 == MAP_FAILED)
  {
    printf("prod: Map failed: %s\n", strerror(errno));
    exit(1);
  }

  /*write to shared memory*/
  ptr_list = shm_base; //inicializar un inventario vacio
  ptr_list->head = 0;
  inventarioInicial(ptr_list); //para prueba

  articulo art;
  char tmp[MAX_NAME_LENGTH];
  int flag2 = 0;

  while (1)
  {
    int opcion, filtro;
    opcion = 0;
    filtro = 0;
    char op;
    int flag = 0;
    system("clear");
    /* Menu principal */
    printf("Bienvenido bodeguero, escoja una opcion:\n");
    printf("\t1: Ver inventario\n");
    printf("\t2: Agregar Articulos\n");
    scanf("%i", &opcion);

    switch (opcion)
    {
    case 1: /* Ver invenatario */
      system("clear");
      printf("Escoja un filtro:\n");
      printf("\t1: Por nombre \n");
      printf("\t2: Por etiqueta \n");
      printf("\t3: Todos los articulos\n");
      scanf("%i", &filtro);
      system("clear");
      switch (filtro)
      {

      case 1:
        printf("Ingrese nombre del articulo\t");
        getchar();
        scanf("%[^\n]s", tmp);
        printf("Mostrando articulos: %s\n", tmp);
        for (int i = 0; i < ptr_list->head; i++)
        {
          if (!strcmp(tmp, ptr_list->articulos[i].name))
          {
            flag = 1;
            putchar('\n');
            printArt(ptr_list->articulos[i]);
          }
        }
        if (flag)
        {
          printf("Hecho, precione enter para continuar\n");
          flag = 0;
        }

        else
        {
          printf("Error, no existe el articulo con nombre %s, presione enter para continuar\n", tmp);
        }

        getchar();
        getchar();

        break;

      case 2:
        printf("Ingrese etiqueta de articulo\t");
        getchar();
        scanf("%[^\n]s", tmp);
        printf("Mostrando articulos con etiqueta: %s\n", tmp);
        for (int i = 0; i < ptr_list->head; i++)
        {
          if (!strcmp(tmp, ptr_list->articulos[i].tag))
          {
            flag = 1;
            putchar('\n');
            printArt(ptr_list->articulos[i]);
          }
        }
        if (flag)
        {
          printf("Hecho, precione enter para continuar\n");
          flag = 0;
        }

        else
        {
          printf("Error, no existen articulos con etiqueta %s, presione enter para continuar\n", tmp);
        }

        getchar();
        getchar();

        break;

      default:
        printf("Mostrando todo\n");
        for (int i = 0; i < ptr_list->head; i++)
        {
          printf("\n%i\n", i + 1);
          printArt(ptr_list->articulos[i]);
        }
        printf("Hecho, precione una tecla para continuar\n");
        getchar();
        getchar();
        break;
      }
      break;

    case 2: /* Agregar Articulos */

      system("clear");
      printf("Escoja una opcion:\n");
      printf("\t1: Articulo existente\n");
      printf("\t2: Articulo nuevo\n");
      getchar();
      op = getchar();

      switch (atoi(&op))
      {
      case 1:
        system("clear");
        printf("Ingrese nombre de articulo\t");
        getchar();
        scanf("%[^\n]s", tmp);
        for (int i = 0; i < ptr_list->head; i++)
        {
          if (!strcmp(tmp, ptr_list->articulos[i].name))
          {
            printf("Ingrese cantidad de articulos agregados\t");
            getchar();
            scanf("%[^\n]s", tmp);
            ptr_list->articulos[i].cantidad += atoi(tmp);
            flag2 = 1;
            break;
          }
        }
        if (flag2)
        {
          printf("Hecho\n");
          flag2 = 0;
          sleep(2);
          break;
        }
        else
        {
          printf("Articulo inexistente\n");
          sleep(2);
          break;
        }

      case 2:
        //crear articulo
        if (ptr_list->head == N)
        {
          printf("Inventario sin espacio\n");
          break;
        }
        printf("Ingrese nombre de articulo\t");
        getchar();
        scanf("%[^\n]s", art.name);
        printf("Precio del articulo\t");
        getchar();
        scanf("%i", &art.precio);
        printf("Descripcion del articulo\t");
        getchar();
        scanf("%[^\n]s", art.descripcion);
        printf("Cantidad del articulo\t");
        getchar();
        scanf("%i", &art.cantidad);
        printf("Etiqueta del articulo\t");
        getchar();
        scanf("%[^\n]s", art.tag);

        //printf("head: %i \ttail: %i \n",ptr->head,ptr->tail);
        ptr_list->articulos[ptr_list->head] = art;
        //move head index
        ptr_list->head++;
      }
      break;

    default:
      printf("Opcion invalida\n");
      sleep(1);
      break;
    }
  }

  /* remove the shared memory segment from the file system */

  /* remove the mapped memory segment from the address space of the process */
  if (munmap(shm_base, SIZE) == -1)
  {
    printf("prod: Unmap failed: %s\n", strerror(errno));
    exit(1);
  }

  if (munmap(shm_base2, SIZE) == -1)
  {
    printf("prod: Unmap failed: %s\n", strerror(errno));
    exit(1);
  }

  /* close the shared memory segment as if it was a file */
  if (close(shm_fd) == -1)
  {
    printf("prod: Close failed: %s\n", strerror(errno));
    exit(1);
  }

  if (close(shm_fd2) == -1)
  {
    printf("prod: Close failed: %s\n", strerror(errno));
    exit(1);
  }

  return 0;
}

void printArt(articulo art)
{
  printf("Nombre: %s\n", art.name);
  printf("Descripcion: %s\n", art.descripcion);
  printf("Precio: %i\n", art.precio);
  printf("Cantidad: %i\n", art.cantidad);
  printf("Etiqueta: %s\n", art.tag);
  return;
}

void inventarioInicial(list *ptr_list)
{
  articulo art;
  strcpy(art.name, "articulo 1");
  strcpy(art.descripcion, "Soy un articulo 1");
  strcpy(art.tag, "tipo A");
  art.precio = 100;
  art.cantidad = 5;
  ptr_list->articulos[ptr_list->head] = art;
  //move head index
  ptr_list->head++;

  strcpy(art.name, "articulo 2");
  strcpy(art.descripcion, "Soy un articulo 2");
  strcpy(art.tag, "tipo B");
  art.precio = 200;
  art.cantidad = 3;
  ptr_list->articulos[ptr_list->head] = art;
  //move head index
  ptr_list->head++;

  strcpy(art.name, "articulo 3");
  strcpy(art.descripcion, "Soy un articulo 3");
  strcpy(art.tag, "tipo C");
  art.precio = 500;
  art.cantidad = 2;
  ptr_list->articulos[ptr_list->head] = art;
  //move head index
  ptr_list->head++;

  strcpy(art.name, "articulo 4");
  strcpy(art.descripcion, "Soy un articulo 4");
  strcpy(art.tag, "tipo A");
  art.precio = 10;
  art.cantidad = 100;
  ptr_list->articulos[ptr_list->head] = art;
  //move head index
  ptr_list->head++;

  strcpy(art.name, "articulo 5");
  strcpy(art.descripcion, "Soy un articulo 5");
  strcpy(art.tag, "tipo C");
  art.precio = 1;
  art.cantidad = 1;
  ptr_list->articulos[ptr_list->head] = art;
  //move head index
  ptr_list->head++;
}