#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/shm.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <errno.h>
#include <semaphore.h>

#include <sys/socket.h>
#include <pthread.h>
#include <arpa/inet.h>

#define MAX_NAME_LENGTH 30
#define MAX_DESCRIPTION_LENGTH 200
#define MAX_TAG_LENGTH 30
#define N 50

typedef struct Articulos
{
	char name[MAX_NAME_LENGTH];				  /* Nombre del aritculo*/
	int precio;								  /* Precio del articulo */
	char descripcion[MAX_DESCRIPTION_LENGTH]; /* Descricion del arituclo */
	int cantidad;							  /* Cantidad disponible del articulo */
	char tag[MAX_TAG_LENGTH];				  /* Etiquetas del articulo */
} articulo;

typedef struct Circular_List
{
	int head; /* first element index */
	articulo articulos[N];
} list;

void printArt(articulo);

int main(int argc, char* argv[])
{
	if(argc != 3)
	{
		printf("Usage is %s <machine> <port>\n",argv[0]);
		exit(-1);
	}
	const char *sh_name = "/inventario"; // shared memory descriptor name
	const char *sh_name2 = "/carrito";   // shared memory descriptor name


	const int SIZE = sizeof(list); // file size
	int shm_fd;					   // file descriptor, from shm_open()
	int shm_fd2;				   // file descriptor, from shm_open()
	list *shm_base;				   // base address, from mmap()
	list *shm_base2;			   // base address, from mmap()
	list *ptr_list;				   // shm_base is fixed, ptr is movable
	list *ptr_list2;			   // shm_base is fixed, ptr is movable

	/* create the shared memory segment as if it was a file */
	shm_fd = shm_open(sh_name, O_CREAT | O_RDWR, 0666);
	if (shm_fd == -1)
	{
		printf("prod: Shared memory failed: %s\n", strerror(errno));
		exit(1);
	}

	shm_fd2 = shm_open(sh_name2, O_CREAT | O_RDWR, 0666);
	if (shm_fd == -1)
	{
		printf("prod: Shared memory failed: %s\n", strerror(errno));
		exit(1);
	}

	/* configure the size of the shared memory segment */
	ftruncate(shm_fd, SIZE);
	ftruncate(shm_fd2, SIZE);

	/* map the shared memory segment to the address space of the process */
	shm_base = mmap(0, SIZE, PROT_READ | PROT_WRITE, MAP_SHARED, shm_fd, 0);
	if (shm_base == MAP_FAILED)
	{
		printf("prod: Map failed: %s\n", strerror(errno));
		exit(1);
	}

	shm_base2 = mmap(0, SIZE, PROT_READ | PROT_WRITE, MAP_SHARED, shm_fd2, 0);
	if (shm_base2 == MAP_FAILED)
	{
		printf("prod: Map failed: %s\n", strerror(errno));
		exit(1);
	}

	//semaforos
	const char *snamec = "/semc";
	const char *snamev = "/semv";
	sem_t *semc,*semv;

	// first remove the semaphore if it already exists
    if (sem_unlink(snamec) == -1)
      printf("Error removing %s: %s\n", snamec, strerror(errno));
	if (sem_unlink(snamev) == -1)
      printf("Error removing %s: %s\n", snamev, strerror(errno));

    // create and initialize the semaphore
    if ((semc = sem_open(snamec, O_CREAT, 0666, 0)) == SEM_FAILED)
      printf("Error creating %s: %s\n", snamec, strerror(errno));
	if ((semv = sem_open(snamev, O_CREAT, 0666, 0)) == SEM_FAILED)
      printf("Error creating %s: %s\n", snamev, strerror(errno));

	//sockets
	int sock;
	struct sockaddr_in server;
	char *machine = argv[1];
	int port = atoi(argv[2]);

    server.sin_addr.s_addr = inet_addr(machine);
    server.sin_family = AF_INET;
    server.sin_port = htons(port);
    //puts("Connected\n");

	/*write to shared memory*/
	ptr_list = shm_base;   //leer inventario
	ptr_list2 = shm_base2; //crear carrito de compras
	ptr_list2->head = 0;

	//variables varias
	char tmp[MAX_NAME_LENGTH]; //para escaneos
	int flag = 0;			   //para casos donde hay que filtrar elememntos
	int j = 1;							//auxiliar para copiar listas
	int indices[N], int_tmp, int_tmp2; 	//auxiliar para copiar listas

	char message[2000], server_reply[2000];//para mensajes
	char nombre[MAX_NAME_LENGTH], tag[MAX_TAG_LENGTH], descripcion[MAX_DESCRIPTION_LENGTH],sprecio[5],scantidad[5];
	int precio, cantidad, total = 0;

	while (1)
	{
		int opcion, filtro;
		opcion = 0;
		filtro = 0;
		//char op;
		system("clear");
		/* Menu principal */
		printf("Bienvenido, escoja una opcion:\n");
		printf("\t1: Ver y agregar articulos\n");
		printf("\t2: Ver carrito\n");
		printf("\t3: Confirmar\n");
		scanf("%i", &opcion);

		switch (opcion)
		{
		case 1: /* Ver invenatarios y agregar al carrito */
			system("clear");
			printf("Escoja un filtro:\n");
			printf("\t1: Por nombre \n");
			printf("\t2: Por etiqueta \n");
			printf("\t3: Todos los articulos\n");
			scanf("%i", &filtro);
			system("clear");
			switch (filtro)
			{

			case 1:
				printf("Ingrese nombre del articulo\t");
				getchar();
				scanf("%[^\n]s", tmp);
				printf("Mostrando articulo: %s\n", tmp);
				for (int i = 0; i < ptr_list->head; i++)
				{
					if (!strcmp(tmp, ptr_list->articulos[i].name))
					{
						flag = 1;
						indices[j] = i;
						printf("\nitem %i\n", j);
						printArt(ptr_list->articulos[i]);
						j++;
					}
				}
				if (flag)
				{
					printf("\ningrese cantidad (maximo %i): \n", ptr_list->articulos[indices[j]].cantidad);
					scanf("%i", &int_tmp);
					ptr_list2->articulos[ptr_list2->head] = ptr_list->articulos[indices[j]];
					ptr_list2->articulos[ptr_list2->head].cantidad = int_tmp;
					total += ptr_list2->articulos[ptr_list2->head].cantidad * ptr_list2->articulos[ptr_list2->head].precio;
					ptr_list2->head++;
					

					printf("Hecho, precione enter para continuar\n");
					flag = 0;
					j = 1;
				}

				else
				{
					printf("Error, no existe el articulo con nombre %s, presione enter para continuar\n", tmp);
				}

				getchar();
				getchar();

				break;

			case 2:
				printf("Ingrese etiqueta de articulo\t");
				getchar();
				scanf("%[^\n]s", tmp);
				printf("Mostrando articulos con etiqueta: %s\n", tmp);
				for (int i = 0; i < ptr_list->head; i++)
				{
					if (!strcmp(tmp, ptr_list->articulos[i].tag))
					{
						flag = 1;
						indices[j-1] = i;
						printf("\nitem %i\n", j);
						printArt(ptr_list->articulos[i]);
						j++;
					}
				}
				if (flag)
				{
					while (flag)
					{
						printf("\nIngrese numero de articulo a agregar (0 para cancelar):");
						scanf("%i", &int_tmp);
						if(!int_tmp)
							break;
						ptr_list2->articulos[ptr_list2->head] = ptr_list->articulos[indices[int_tmp-1]];
						printf("\ningrese cantidad (maximo %i): ", ptr_list->articulos[indices[int_tmp-1]].cantidad);
						scanf("%i", &int_tmp2);
						ptr_list2->articulos[ptr_list2->head].cantidad = int_tmp2;
						total += ptr_list2->articulos[ptr_list2->head].cantidad * ptr_list2->articulos[ptr_list2->head].precio;
						ptr_list2->head++;
						printf("\nHecho, ¿desea agregar otro articulo?\n");
						printf("1 Si\n");
						printf("2 No\n");
						scanf("%i", &int_tmp2);
						
						if(int_tmp2 == 2)
						{
							flag = 0;
							break;
						}							
					}
				}

				else
				{
					printf("Error, no existen articulos con etiqueta %s, presione enter para continuar\n", tmp);
				}
				getchar();

				break;

			default:
				printf("Mostrando todo\n");
				for (int i = 0; i < ptr_list->head; i++)
				{
						flag = 1;
						indices[j-1] = i;
						printf("\nitem %i\n", j);
						printArt(ptr_list->articulos[i]);
						j++;
					
				}
				if (flag)
				{
					while (flag)
					{
						printf("\nIngrese numero de articulo a agregar (0 para cancelar):");
						scanf("%i", &int_tmp);
						if(!int_tmp)
							break;
						ptr_list2->articulos[ptr_list2->head] = ptr_list->articulos[indices[int_tmp-1]];
						printf("\ningrese cantidad (maximo %i): ", ptr_list->articulos[indices[int_tmp-1]].cantidad);
						scanf("%i", &int_tmp2);
						ptr_list2->articulos[ptr_list2->head].cantidad = int_tmp2;
						total += ptr_list2->articulos[ptr_list2->head].cantidad * ptr_list2->articulos[ptr_list2->head].precio;
						ptr_list2->head++;
						printf("\nHecho, ¿desea agregar otro articulo?\n");
						printf("1 Si\n");
						printf("2 No\n");
						scanf("%i", &int_tmp2);
						
						if(int_tmp2 == 2)
						{
							flag = 0;
							j = 1;
							break;
						}							
					}
				}
				printf("Hecho, precione una tecla para continuar\n");
				getchar();
				break;
			}
			break;

		case 2: /* Ver carrito de compras */
			system("clear");
			for (int i = 0; i < ptr_list2->head; i++)
			{
				printf("\n%i\n", i + 1);
				printArt(ptr_list2->articulos[i]);
			}
			printf("El total es de %i, precione una tecla para continuar\n", total);
			getchar();
			getchar();
			break;

		case 3: /* Confirmar compra */

		//Create socket
		sock = socket(AF_INET, SOCK_STREAM, 0);
		if (sock == -1)
		{
			printf("Could not create socket");
		}
		//puts("Socket created");

		//Connect to remote server
		if (connect(sock, (struct sockaddr *)&server, sizeof(server)) < 0)
		{
			perror("connect failed. Error");
			return 1;
		}

		if(ptr_list2->head == 0)
		{
			printf("Error, carrito de compras vacio, pulse enter para continuar\n");
			getchar();
			getchar();
			break;
		} 

		while(1)
		{

			message[0]='S';								//indicar que comienza un stream
			sprintf(message+1,"%d",ptr_list2->head);	//primero ve el numero de articulos que espera
			send(sock, message, strlen(message)+1, 0);	//enviar request
			sem_wait(semc);
			for(int i = 0; i<ptr_list2->head;i++)
			{
				strcpy(nombre,ptr_list2->articulos[i].name);
				strcpy(descripcion,ptr_list2->articulos[i].descripcion);
				strcpy(tag,ptr_list2->articulos[i].tag);
				precio = ptr_list2->articulos[i].precio;
				sprintf(sprecio,"%d",precio);
				cantidad = ptr_list2->articulos[i].cantidad;
				sprintf(scantidad,"%d",cantidad);
				strcpy(message,nombre);
				strcpy(message+strlen(nombre),",");
				strcpy(message+strlen(nombre)+1,descripcion);
				strcpy(message+strlen(nombre)+strlen(descripcion)+1,",");
				strcpy(message+strlen(nombre)+strlen(descripcion)+2,tag);
				strcpy(message+strlen(nombre)+strlen(descripcion)+strlen(tag)+2,",");
				strcpy(message+strlen(nombre)+strlen(descripcion)+strlen(tag)+3,sprecio);
				strcpy(message+strlen(nombre)+strlen(descripcion)+strlen(tag)+strlen(sprecio)+3,",");
				strcpy(message+strlen(nombre)+strlen(descripcion)+strlen(tag)+strlen(sprecio)+4,scantidad);
				strcpy(message+strlen(nombre)+strlen(descripcion)+strlen(tag)+strlen(sprecio)+strlen(scantidad)+4,",");
				send(sock, message, strlen(message)+1, 0);	//enviar datos
				sem_post(semv);
				sem_wait(semc);
			}
			printf("Proceda a pagar en caja\n");
			sem_post(semv);
			if (recv(sock, server_reply, 2000, 0) < 0)
			{
				puts("recv failed");
				break;
			}
        	printf("Gracias por su compra, proceda a retirar los articulos\n");
			//decrementar inventario
			for(int i = 0; i < ptr_list2->head; i++)
				for(int k = 0; k < ptr_list->head;k++)
					if(!strcmp(ptr_list2->articulos[i].name,ptr_list->articulos[k].name))
						ptr_list->articulos[k].cantidad -= ptr_list2->articulos[i].cantidad;
			//borrar carrito
			ptr_list2->head = 0;
			total = 0;
					
        	sleep(5);
			close(sock);
			break;
		}

			break;

		default:
			printf("Opcion invalida\n");
			sleep(1);
			break;
		}
	}

	/* remove the shared memory segment from the file system */

	/* remove the mapped memory segment from the address space of the process */
	if (munmap(shm_base, SIZE) == -1)
	{
		printf("prod: Unmap failed: %s\n", strerror(errno));
		exit(1);
	}

	if (munmap(shm_base2, SIZE) == -1)
	{
		printf("prod: Unmap failed: %s\n", strerror(errno));
		exit(1);
	}

	/* close the shared memory segment as if it was a file */
	if (close(shm_fd) == -1)
	{
		printf("prod: Close failed: %s\n", strerror(errno));
		exit(1);
	}

	if (close(shm_fd2) == -1)
	{
		printf("prod: Close failed: %s\n", strerror(errno));
		exit(1);
	}

	return 0;
}

void printArt(articulo art)
{
	printf("Nombre: %s\n", art.name);
	printf("Descripcion: %s\n", art.descripcion);
	printf("Precio: %i\n", art.precio);
	printf("Cantidad: %i\n", art.cantidad);
	printf("Etiqueta: %s\n", art.tag);
	return;
}