#include <sys/socket.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pthread.h>
#include <arpa/inet.h>

#include <fcntl.h>
#include <sys/shm.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <errno.h>
#include <semaphore.h>

#define MAX_NAME_LENGTH 30
#define MAX_DESCRIPTION_LENGTH 200
#define MAX_TAG_LENGTH 30
#define N 50

typedef struct Articulos
{
	char name[MAX_NAME_LENGTH];				  /* Nombre del aritculo*/
	int precio;								  /* Precio del articulo */
	char descripcion[MAX_DESCRIPTION_LENGTH]; /* Descricion del arituclo */
	int cantidad;							  /* Cantidad disponible del articulo */
	char tag[MAX_TAG_LENGTH];				  /* Etiquetas del articulo */
} articulo;

typedef struct Circular_List
{
	int head; /* first element index */
	articulo articulos[N];
} list;

typedef struct parameter
{
	int *sock;
} parametro;

//the thread function
void *connection_handler(void *);

void printArt(articulo);

// Mutex
pthread_mutex_t myMutex = PTHREAD_MUTEX_INITIALIZER;

int main(int argc, char* argv[])
{
	if(argc != 2)
	{
		printf("Usage is %s <port>\n",argv[0]);
		exit(-1);
	}
	int pin, client_sock, c, *new_sock;
	struct sockaddr_in server, client;

	int port = atoi(argv[1]);

	//Create socket
	pin = socket(AF_INET, SOCK_STREAM, 0);
	if (pin == -1)
	{
		printf("Could not create socket");
	}
	//puts("Socket created");

	//Prepare the sockaddr_in structure
	server.sin_family = AF_INET;
	server.sin_addr.s_addr = INADDR_ANY;
	server.sin_port = htons(port);

	//Bind
	if (bind(pin, (struct sockaddr *)&server, sizeof(server)) < 0)
	{
		//print the error message
		perror("bind failed. Error");
		return 1;
	}
	//puts("bind done");

	//Listen
	listen(pin, 3);

	//Accept and incoming connection
	system("clear");
	puts("Bienvenido vendedor\nEsperando por Clientes");
	c = sizeof(struct sockaddr_in);

	while ((client_sock = accept(pin, (struct sockaddr *)&client, (socklen_t *)&c)))
	{
		puts("Nuevo cliente");

		pthread_t sniffer_thread;
		new_sock = malloc(1);
		*new_sock = client_sock;

		//estructura para paso de parametros a cada hilo

		parametro p1;
		p1.sock = &client_sock;

		if (pthread_create(&sniffer_thread, NULL, connection_handler, (void *)&p1) < 0)
		{
			perror("could not create thread");
			return 1;
		}
		pthread_join( sniffer_thread , NULL);
		system("clear");

		puts("Esperando por Clientes");
		char c = getchar();
		if(c == 'c')
			break;

	}

	if (client_sock < 0)
	{
		perror("accept failed");
		return 1;
	}
	free(new_sock);
	
	pthread_mutex_destroy(&myMutex);
	return 0;
}

/*
 * This will handle connection for each client
 * */
void *connection_handler(void *pin)
{

	parametro p = *(parametro *)pin;

	//Get the socket descriptor
	int sock = *p.sock;

	//semaforos
	const char *snamec = "/semc";
	const char *snamev = "/semv";
	sem_t *semc, *semv;

	// create and initialize the semaphore
	if ((semc = sem_open(snamec, 0)) == SEM_FAILED)
		printf("Error opening %s: %s\n", snamec, strerror(errno));
	if ((semv = sem_open(snamev, 0)) == SEM_FAILED)
		printf("Error opening %s: %s\n", snamev, strerror(errno));

	int read_size;
	char client_message[2000];// server_message[2000];

	list lista;
	lista.head = 0;
	char *token;
	int total = 0;

	//Receive a message from client
	while ((read_size = recv(sock, client_message, 2000, 0)) > 0)
	{
		pthread_mutex_lock(&myMutex);
		if (client_message[0] == 'S') //comienza una trasmision
		{
			int x = atoi(client_message + 1); //numero de elementos que se esperan
			sem_post(semc);
			sem_wait(semv);
			for (int i = 0; i < x; i++)
			{
				recv(sock, client_message, 2000, 0);
				//printf("client message: %s\n",client_message);
				
				token = strtok(client_message,",");
				strcpy(lista.articulos[lista.head].name,token);
				token = strtok(NULL,",");
				strcpy(lista.articulos[lista.head].descripcion,token);
				token = strtok(NULL,",");
				strcpy(lista.articulos[lista.head].tag,token);
				token = strtok(NULL,",");
				lista.articulos[lista.head].precio = atoi(token);
				token = strtok(NULL,",");
				lista.articulos[lista.head].cantidad = atoi(token);
				total += lista.articulos[lista.head].precio * lista.articulos[lista.head].cantidad;
				//printArt(lista.articulos[lista.head]);
				lista.head++;

				sem_post(semc);
				sem_wait(semv);
			}

		}

		printf("Total de la venta: %i\n\n",total);
		printf("Pulse enter cuando la transaccion halla sido completada\n");
		getchar();
		pthread_mutex_unlock(&myMutex);
		break;
	}

	if (read_size == 0)
	{
		puts("Client disconnected");
		fflush(stdout);
	}
	else if (read_size == -1)
	{
		perror("recv failed");
	}

	
	//cerrar semaforos
	sem_close(semc);
	sem_close(semv);

	//Free the socket pointer
	close(sock);
	//free(p.sock);
	return 0;
}

void printArt(articulo art)
{
  printf("Nombre: %s\n", art.name);
  printf("Descripcion: %s\n", art.descripcion);
  printf("Precio: %i\n", art.precio);
  printf("Cantidad: %i\n", art.cantidad);
  printf("Etiqueta: %s\n", art.tag);
  return;
}